@extends('admin.layout.template')
@section('title', 'Users')

@section('content')

@extends('admin.layout.template')

@section('title', 'User Profile')

@section('content')
<div class="page-content">
    <div class="container-xxl">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 py-0">
                <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{route('users.index')}}">Users</a></li>
            </ol>
        </nav>
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4>Users</h4>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#userModal">
                    + Add User
                </button>

            </div>

            <div class="card-body">
                <table id="usersTable" class="table  table-striped table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Role</th>
                            <th>Reporting Manager</th>
                            <th>Department</th>
                            <th>Status</th>
                            <th width="160">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $i => $user)
                        <tr id="row-{{ $user->id }}">
                            <td>{{ $i+1 }}</td>
                            <td>{{ $user->name }}
                                @if($user->isOnline())
                                <span class="badge bg-success">Online</span>
                                @else
                                <span class="badge bg-secondary">Offline</span>
                                @endif
                                <span class="d-flex align-items-center">
                            </td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->phone }}</td>
                            <td>{{ $user->roles->pluck('name')->first() }}</td>

                            {{-- Reporting Manager --}}
                            <td>{{ $user->manager ? $user->manager->name : '-' }}</td>

                            {{-- Department --}}
                            <td>{{ $user->department ? $user->department->name : '-' }}</td>

                            <td>

                                @if($user->status=='Active')
                                <span class="badge bg-success-subtle text-success py-1 px-2">{{$user->status}}</span>
                                @else
                                <span class="badge bg-success-subtle text-danger py-1 px-2">{{$user->status}}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('users.view', $user->id) }}"
                                    class="btn btn-sm btn-info">
                                    <iconify-icon icon="solar:eye-bold-duotone"></iconify-icon>

                                </a>

                                <button class="btn btn-sm btn-warning editUser" data-id="{{ $user->id }}"><iconify-icon icon="solar:pen-bold-duotone"></iconify-icon>
                                </button>
                                <button class="btn btn-sm btn-danger deleteUser" data-id="{{ $user->id }}"><iconify-icon icon="solar:trash-bin-trash-bold-duotone"></iconify-icon>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @include('admin.users.modal')

    </div>
</div>

<script>
    const usersBaseUrl = "{{ url('/users') }}";


    $(document).ready(function() {
        $('#usersTable').DataTable({
            pageLength: 10,
            ordering: true,
            responsive: true
        });
    });
    /* ADD */
    $('#userForm').submit(function(e) {
        e.preventDefault();

        let id = $('#user_id').val();
        let url = id ? `${usersBaseUrl}/${id}` : usersBaseUrl;

        Swal.fire({
            title: 'Are you sure?',
            text: 'Save user details?',
            icon: 'question',
            showCancelButton: true
        }).then((res) => {
            if (res.isConfirmed) {
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: $(this).serialize() + (id ? '&_method=PUT' : ''),
                    success: function(res) {
                        Swal.fire('Success', res.message, 'success')
                            .then(() => location.reload());
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let errorMessages = [];

                            // Collect all error messages
                            for (const key in errors) {
                                if (errors.hasOwnProperty(key)) {
                                    errorMessages.push(errors[key].join('<br>'));
                                }
                            }

                            Swal.fire({
                                title: 'Validation Error',
                                html: errorMessages.join('<br>'),
                                icon: 'error'
                            });
                        } else {
                            Swal.fire('Error', 'Something went wrong!', 'error');
                        }
                    }
                });
            }
        });
    });


    /* EDIT */
    /* EDIT */
    $('.editUser').click(function() {
        let id = $(this).data('id');

        $.get(`${usersBaseUrl}/${id}/edit`, function(res) {
            $('#user_id').val(res.user.id);
            $('[name=name]').val(res.user.name);
            $('[name=email]').val(res.user.email);
            $('[name=phone]').val(res.user.phone);
            $('[name=joining_date]').val(res.user.joining_date);
            $('[name=access_expires_at]').val(res.user.access_expires_at);

            // Open modal first
            $('#userModal').modal('show');

            setTimeout(() => {
                $('[name=role]').val(res.role).trigger('change');
                $('[name=status]').val(res.user.status).trigger('change');
                $('[name=user_type]').val(res.user.user_type).trigger('change');
                $('[name=department_id]').val(res.user.department_id).trigger('change');
                $('[name=reporting_manager_id]').val(res.user.reporting_manager_id).trigger('change');
            }, 100);
        });
    });



    /* DELETE */
    $('.deleteUser').click(function() {
        let id = $(this).data('id');

        Swal.fire({
            title: 'Are you sure?',
            text: 'Delete user details?',
            icon: 'warning',
            showCancelButton: true
        }).then(res => {
            if (res.isConfirmed) {
                $.ajax({
                    url: `/users/${id}`,
                    type: 'POST',
                    data: {
                        _method: 'DELETE',
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(res) {
                        Swal.fire('Deleted', res.message, 'success');
                        $('#row-' + id).remove();
                    }
                })
            }
        });
    });

    $(document).on('change', '#department_id', function() {
        var departmentId = $(this).val();

        if (departmentId) {
            $.ajax({
                url: "{{ url('get.department.users') }}/" + categoryId,
                type: 'GET',
                success: function(data) {
                    userSelect.empty();
                    userSelect.append('<option value="">-- Select users --</option>');
                    $.each(data, function(key, user) {
                        userSelect.append('<option value="' + user.id + '">' + user.name + '</option>');
                    });
                }
            });
        } else {
            userSelect.empty().append('<option value="">-- Select users --</option>');
        }
    });
</script>

@endsection